#pragma rtGlobals=1		// Use modern global access method.

function SelectEnergy(particle,energy, denergy,w)
	variable energy, denergy
	string particle
	wave w
	WAVE e_part = $("e_"+particle)
	w=(abs(e_part-energy)<denergy)
end

//-------------------------------------------------------------------------------------------------------------------------------------------------------------       

function OrientLight(particle,thet,dthet,phi,dphi,w)
	variable thet,dthet,dphi,phi
	string particle
	wave w
	
	WAVE thet_part = $("thet_"+particle)
	WAVE phi_part = $("phi_"+particle)
	w*=  (abs(thet_part-thet)<dthet)%&  (abs(phi_part-phi)<dphi)
end

//-------------------------------------------------------------------------------------------------------------------------------------------------------------       

function OrientLab(particle,thet,dthet,phi,dphi,w)
	variable thet,dthet,dphi,phi
	string particle
	wave w
	WAVE thet_part = $("dvthet_"+particle)
	WAVE phi_part = $("dvphi_"+particle)
	w*= (abs(thet_part-thet)<dthet)%&  (abs(abs(phi_part)-phi)<dphi)
end
//-------------------------------------------------------------------------------------------------------------------------------------------------------------       

function Aligne(particle1, particle2, dcone,w)
	string particle1, particle2
	variable dcone
	wave w
	
	WAVE thet12 = $("thet_"+particle1+particle2)

	w*= (abs(thet12-Pi)<dcone)
end
//-------------------------------------------------------------------------------------------------------------------------------------------------------------       

function Coplanar(particle1, particle2, x3,y3,z3,dp,w)
string particle1, particle2
variable x3,y3,z3,dp
wave w	

WAVE x1= $("px_"+particle1)
WAVE y1= $("py_"+particle1)
WAVE z1= $("pz_"+particle1)

WAVE x2= $("px_"+particle2)
WAVE y2= $("py_"+particle2)
WAVE z2= $("pz_"+particle2)
	
variable NbPoints=numpnts(x1),i,r1,r2,r3,x12,y12,z12,sinus,cosinus
for (i=0; i<Nbpoints; i+=1)
	r1=sqrt(x1[i]^2+y1[i]^2+z1[i]^2)  //Vector norms
	r2=sqrt(x2[i]^2+y2[i]^2+z2[i]^2)
	r3=sqrt(x3^2+y3^2+z3^2)
	x12=(y1[i]*z2[i]-z1[i]*y2[i])	//Vectorial product
	y12=(z1[i]*x2[i]-x1[i]*z2[i])
	z12=(x1[i]*y2[i]-y1[i]*x2[i])
	sinus=sqrt(x12^2+y12^2+z12^2)/(r1*r2)
	cosinus= (x12*x3+y12*y3+z12*z3)/(r1*r2*r3*sinus) //Vectorial product * Scalar product => Coplanarity criteria 
	w[i]*=abs(acos(cosinus))<dp
endfor
end

//-------------------------------------------------------------------------------------------------------------------------------------------------------------       

function Trihedron(particle1, particle2, x3,y3,z3,dp,w)
string particle1, particle2
variable x3,y3,z3,dp
wave w	

WAVE x1= $("px_"+particle1)
WAVE y1= $("py_"+particle1)
WAVE z1= $("pz_"+particle1)

WAVE x2= $("px_"+particle2)
WAVE y2= $("py_"+particle2)
WAVE z2= $("pz_"+particle2)
	
variable NbPoints=numpnts(x1),i,r1,r2,r3,x12,y12,z12,sinus,cosinus
for (i=0; i<Nbpoints; i+=1)
	r1=sqrt(x1[i]^2+y1[i]^2+z1[i]^2)  //Vector norms
	r2=sqrt(x2[i]^2+y2[i]^2+z2[i]^2)
	r3=sqrt(x3^2+y3^2+z3^2)
	x12=(y1[i]*z2[i]-z1[i]*y2[i])	//Vectorial product
	y12=(z1[i]*x2[i]-x1[i]*z2[i])
	z12=(x1[i]*y2[i]-y1[i]*x2[i])
	sinus=sqrt(x12^2+y12^2+z12^2)/(r1*r2)
	cosinus= (x12*x3+y12*y3+z12*z3)/(r1*r2*r3*sinus) //Vectorial product * Scalar product => Trihedron criteria 
	w[i]*= abs(acos(cosinus))>1-dp
endfor
end

//-------------------------------------------------------------------------------------------------------------------------------------------------------------       
//												PONDERATION
//-------------------------------------------------------------------------------------------------------------------------------------------------------------  
function ponder1D(w)
	wave w
	string Name
	variable x0, dx
	x0=leftx(w)
	dx=deltax(w)
	name=nameofwave(w)
	duplicate/O w, $(name+"_pond")
	execute(name+"_pond="+name+"/abs(sin(x))")
	execute(name+"_pond="+name+"_pond/area("+name+"_pond,0,Inf)*area("+name+",0,Inf)")
end
//-------------------------------------------------------------------------------------------------------------------------------------------------------------       
//												InvertSum
//-------------------------------------------------------------------------------------------------------------------------------------------------------------  
function InvertSum(w1,w2)
	wave w1,w2
	variable i,size=numpnts(w1)
	for (i=0;i<size;i+=1)
		w1[i]+=w2[size-i]
	endfor
end



//-------------------------------------------------------------------------------------------------------------------------------------------------------------       
//												ThetSpher2Pol
//-------------------------------------------------------------------------------------------------------------------------------------------------------------  
function ThetSpher2Pol(particle1,particle2, x3,y3,z3, w)
String particle1, particle2
variable x3,y3,z3
wave w

WAVE x1= $("px_"+particle1)
WAVE y1= $("py_"+particle1)
WAVE z1= $("pz_"+particle1)

WAVE x2= $("px_"+particle2)
WAVE y2= $("py_"+particle2)
WAVE z2= $("pz_"+particle2)

WAVE thet= $("thet_"+particle2)

variable NbPoints=numpnts(x1),i,s
for (i=0; i<Nbpoints; i+=1)
	w[i]=0
	s=sign(x1[i]*x2[i]*(1-x3^2)+y1[i]*y2[i]*(1-y3^2)+z1[i]*z2[i]*(1-z3^2))

	if (s>0) 
		w[i]=thet[i] 
	else
		w[i]=2*Pi-thet[i] 
	endif
	endfor
end
